format_for_ggplot <- function(data, conditions){
  colnames <- c("condition", "time", "n", "total_dead", "survival", conditions)
  new_df <- data.frame(matrix(ncol = length(colnames), nrow = 0))
  names(new_df) <- colnames
  unique_groups <- unique(data$condition)

  #cycle through each unique condition, keeping technical replicates separate
  for(group in unique_groups){
    #grab just the data from current group
    group_data <- subset(data, condition == group)
    #calculate total noncensored population
    group_pop <- nrow(group_data) - sum(group_data$censored == 0)
    first_row <- c(group, 0, group_pop, 0, 100)
    second_row <- c(group, 10, group_pop, 0,100)
    for(i in conditions){
      first_row <- append(first_row, group_data[1,i])
      second_row <- append(second_row, group_data[1,i])
    }
    new_df[nrow(new_df) + 1,] <-first_row
    day10_deaths <- nrow(group_data[group_data$time == 10,])
    if(day10_deaths == 0){
      new_df[nrow(new_df) + 1,] <-second_row
    }
    
    #calculate total dead on each day then divide by population to get survival
    unique_days <- unique(group_data$time)
    for(day in unique_days){
      total_dead <- nrow(group_data[(group_data$time <= day & group_data$censored == 1),])
      survival <- (group_pop-total_dead)/group_pop *100
      
      new_row <- c(group, day, group_pop, total_dead, survival)
      for(i in conditions){
        new_row <- append(new_row, group_data[1,i])
      }
      new_df[nrow(new_df) + 1,] <-new_row
    }
  }
  new_df$time <- as.numeric(new_df$time)
  new_df$survival <- as.numeric(new_df$survival)
  return(new_df)
}